# Llamar a la base de datos
datos<- read.csv2("b.seco.csv",row.names=1)
head(datos)
str(datos)

#-----------------------------------------------------------------------
# LIBRERAS REQUERIDAS
library(ellipse)
require(gclus)
require(SciViews)
require(ade4)
library(ggplot2)
require(vegan)
library(corrplot)

#-----------------------------------------------------------------------
# GRAFICAS EXPLORATORIAS

# 1. Figura de correlaciones iniciales
x11()
plotcorr(cor(datos[,c(2:5)]))
plotcorr(cor(log10(datos[,c(3:6)])))
plotcorr(cor(sqrt(datos[,c(3:6)])))
plotcorr(cor(sqrt(sqrt(datos[,c(3:6)]))))
plotcorr(cor(1/(datos[,c(3:6)])))


# 2. Figura de correlaciones con colores
M <- cor(datos[,c(3:6)])     # Matriz de Correlacin (M)
x11()                            # Panel grfico adicional
corrplot(M, method = "ellipse")  # Figura de correlaciones con elipses
corrplot.mixed(M, upper="ellipse")


# 3. Diagrama de correlaciones
pairs (datos[,c(3:6)], lower.panel=panel.smooth,
       upper.panel=panel.cor, diag.panel=panel.hist,
       main="Matriz de Correlacin de Pearson")


# 4. Grafica de pares
x11()
pairs(datos[,c(3:6)],panel=function(x,y)
      {abline(lsfit(x,y)$coef,lwd=2,col=3)
      lines(lowess(x,y),lty=2,lwd=2,col=2)
      points(x,y, col=datos$Abr, cex=1.4)})


#==================================================================
# SIETE (7) TIPOS DE CLUSTERS JERRQUICOS

# PASO 1. Distancia entre observaciones
# Matriz de distancia
d.euclid <- dist(log10(datos[,c(2:5)]+1))

#--------------
# (1) Vecino ms cercano "Cl.single", funcin "hclust" y mtodo "single"
Cl.single <- hclust(d.euclid,method="single")
# Figura
plot(Cl.single, ylab="Distancia Euclidea", cex.lab=1.5,xlab="",
     main="Vecino ms Cercano", cex.main=1.5,col.main=4,cex=0.7, 
     sub="")

# (2) Vecino ms lejano "Cl.complete", funcin "complete"  
Cl.complete<-hclust(d.euclid,method="complete")
plot(Cl.complete,ylab="Distancia Euclidea", cex.lab=1.5,xlab="",
     main="Vecino ms Lejano", cex.main=2,col.main=4, sub="")


# (3) UPGMA funcin "average" Unin Promedio no Ponderado
Cl.upgma<-hclust(d.euclid,method="average")
plot(Cl.upgma,ylab="Distancia Euclidea", cex.lab=1.5,xlab="",
     main="Union Promedio no Ponderada (UPGMA)", cex.main=1.5,col.main=4)
     

# (4) WPGMA funcin "mcquitty"
Cl.wpgma<-hclust(d.euclid,method="mcquitty")
plot(Cl.wpgma,ylab="Distancia Euclidea", cex.lab=1.5,xlab="",
     main="Union Promedio Ponderada (WPGMA)", cex.main=1,col.main=4)
     

# (5) UPGMC funcin "centroid"
Cl.upgmc<-hclust(d.euclid,method="centroid")
plot(Cl.upgmc,ylab="Distancia Euclidea", cex.lab=1.5,xlab="",
     main="Union Centroide no Ponderada (UPGMC)", cex.main=1,col.main=4)


# (6) WPGMC funcin "median"
Cl.median<-hclust(d.euclid,method="median")
plot(Cl.median,ylab="Distancia Euclidea", cex.lab=1.5,xlab="",
     main="Unin Centroide Ponderado (WPGMC)", cex.main=1,col.main=4)


# (7) WARD, funcin "ward"
Cl.ward<-hclust(d.euclid,method="ward.D")
plot(Cl.ward,ylab="Distancia Euclidea", cex.lab=1.5,xlab="",
     main="Union de Ward (WARD)", cex.main=1,col.main=4)



#------------------------------------- 
# PAO 2. Seleccionar mejor mtodo de agrupacin
# CORRELACIONES COFENTICAS 
   
# (1) Correlacin cofentica  para "single"
cofenet1 <- cophenetic(Cl.single)
cor(d.euclid,cofenet1)

# (2) Correlacin cofentica  para "complete"
cofenet2<-cophenetic(Cl.complete)
cor(d.euclid,cofenet2)

# (3) Correlacin cofentica  para "average"
cofenet3<-cophenetic(Cl.upgma)
cor(d.euclid,cofenet3)

# (4) Ccorrelacin cofentica  para "mcquitty"
cofenet4<-cophenetic(Cl.wpgma)
cor(d.euclid,cofenet4)

# (5) Correlacin cofentica  para "centroid"
cofenet5<-cophenetic(Cl.upgmc)
cor(d.euclid,cofenet5)

# (6) Correlacin cofentica  para "mmedian"
cofenet6<-cophenetic(Cl.median)
cor(d.euclid,cofenet6)

# (7) Correlacin cofentica  para "ward"
cofenet7<-cophenetic(Cl.ward)
cor(d.euclid,cofenet7)

# data frame con cofenticos
cofeneticos = data.frame(simple=cor(d.euclid,cofenet1),compl=cor(d.euclid,cofenet2),
                         upgma=cor(d.euclid,cofenet3),upgmc=cor(d.euclid,cofenet4),
                         wpgma=cor(d.euclid,cofenet5),wpgmc=cor(d.euclid,cofenet6),
                         ward=cor(d.euclid,cofenet7))
cofeneticos

# cofenticos por cada mtodos (Met)
cofenet=data.frame(Met = 1:7,Cofen=t(round(cofeneticos,3)))
cofenet

# tabla con orden descendente de cofenticos
cof_ordenado = cofenet[order(cofenet$Cofen, decreasing = TRUE), ]
cof_ordenado

# guardar tabla como csv
write.csv2(cof_ordenado,"cofenet.csv")



#-------------------------------------
# Figuras correlaciones cofenticas
x11()
par(mfrow=c(2,2))
# (1) distancia cofentica  para "single" 
plot1<-plot(d.euclid,cofenet1,
            xlab="Distancia Euclidea",ylab="Distancia Cofentica",
            main=c("Unin Simple",paste("Correlacin Cofentica",
            round(cor(d.euclid,cofenet1),3))))
            abline(0,1)
            lines(lowess(d.euclid,cofenet1),col=2)
# (2) Correlacin cofentica  para "complete"
plot2<-plot(d.euclid,cofenet2,
            xlab="Distancia Euclidea",ylab="Distancia Cofentica",
            main=c("Unin Completa",paste("Correlacin Cofentica",
            round(cor(d.euclid,cofenet2),4))))
            abline(0,1)
            lines(lowess(d.euclid,cofenet2),col=2)
# (3) Correlacin cofentica  para "average"
plot3<-plot(d.euclid,cofenet3,
            xlab="Distancia Euclidea",ylab="Distancia Cofentica",
            main=c("Unin Promedio no Ponderada-UPGMA",paste("Correlacin Cofentica",
            round(cor(d.euclid,cofenet3),4))))
            abline(0,1)
            lines(lowess(d.euclid,cofenet3),col=2)
# (4) Ccorrelacin cofentica  para "mcquitty"
plot1<-plot(d.euclid,cofenet4,
            xlab="Distancia Euclidea",ylab="Distancia Cofentica",
            main=c("Unin Promedio Ponderada-WPGMA",paste("Correlacin Cofentica",
            round(cor(d.euclid,cofenet4),3))))
            abline(0,1)
            lines(lowess(d.euclid,cofenet4),col=2)
par(mfrow=c(1,1))



# ------------------------------------------------------------------
# PASO 3. Nmero de grupos formados - Opcin 1 (Niveles de Fusin)

# Base de variables a relacionar (amb)
amb<-log10(datos[,c(2:5)]+1)

# Grafico para valores de niveles de fusin
x11()
plot(Cl.upgma$height, nrow(amb):2, type="S", 
	main="Niveles de fusin - Distancia Eucldea - UPGMA", 
	ylab="k (Nmero de Cluster)", xlab="h (Altura del Nodo)", col="grey")
  text(Cl.upgma$height, nrow(amb):2, nrow(amb):2, col="red", cex=0.8)

# La figura muestra el escaln ms prolongado en 2 grupos

  
  
  
# ------------------------------------------------------------------
# PASO 3. Nmero de grupos formados - Opcin 2 (Amplitud de Silueta)
# Nmero optimo de clusters de acuerdo al Ancho de silueta
# ndice de calidad de Rousseeuw      

# 1. Crear un vector vaco (amb.vacio) con asw valores
amb.vacio <- numeric(nrow(amb))

# 2. Silueta "sil" 
for(k in 2: (nrow(amb)-1)){
    sil <- silhouette(cutree(Cl.upgma,k=k),d.euclid)
    amb.vacio[k]<-summary(sil)$avg.width} 

# 3. Mejor o mayor amplitud de silueta (2 particiones)
k.mejor <- which.max(amb.vacio)
k.mejor 

# Grafica de silueta
plot(1:nrow(amb),amb.vacio,type="h",
     main="Silueta-Nmero ptimo de Clusters", xlab="(nmero de grupos)",
     ylab="Amplitud promedio de  silueta")
     
axis(1,k.mejor,paste("optimum",k.mejor,sep="\n"),col="red",
     font=2,col.axis="red")
     
points(k.mejor,max(amb.vacio),pch=16,col="red",cex=1.5)

cat("","Silueta-Nmero ptimo de Clusters k=",k.mejor,
    "\n","Con una aplitud promedio de silueta",max(amb.vacio),"\n")


# --------------------------------------------------------------------
# Dendograma final
amb.upgma <- reorder.hclust(Cl.upgma,d.euclid)
# Figura
plot (amb.upgma,ylab="Distancia Euclidea", cex.lab=1.2,xlab="2 grupos",
     main="Union Promedio no Ponderada (UPGMA)", cex.main=1,col.main=4,
      sub="")         
rect.hclust(amb.upgma,k=2,border = 2)

#------------------------
# PASO 4. Variables que mejor clasifican (Mapas de Calor)

# Base de datos sin row.names=1
amb1<-read.csv2("FQmarino.csv")
amb1
str(amb1)

# Para el ejercicio se escogen variables contnuas       
amb2<-as.matrix(amb1[,c(3:9)])
amb2

# Se escoge la baha como la observaciones a graficar 
rownames(amb2)<-amb1[,1]
amb2

# Mapa
hv <- heatmap(amb2, margins=c(10,10), xlab ="Variables fsico-qumicas", 
              ylab= "Bahas", main = "Clasificacin de Bahas",
              scale = "column")
              
help(heatmap)
